/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.ceramics;

import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.container.CapabilityContainerListener;
import net.dries007.tfc.objects.container.ContainerEmpty;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ceramics.ItemPottery;
import net.dries007.tfc.objects.recipes.UnmoldRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class ItemMold
extends ItemPottery {
    private static final EnumMap<Metal.ItemType, ItemMold> MAP = new EnumMap(Metal.ItemType.class);
    private final Metal.ItemType type;

    public static ItemMold get(Metal.ItemType category) {
        return MAP.get((Object)category);
    }

    public ItemMold(Metal.ItemType type) {
        this.type = type;
        if (MAP.put(type, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            if (!player.func_70093_af() && cap != null && cap.isMolten()) {
                TFCGuiHandler.openGui(world, player, TFCGuiHandler.Type.MOLD);
            }
            if (player.func_70093_af()) {
                InventoryCrafting craftMatrix = new InventoryCrafting((Container)new ContainerEmpty(), 3, 3);
                craftMatrix.func_70299_a(0, stack);
                for (IRecipe recipe : ForgeRegistries.RECIPES.getValuesCollection()) {
                    ItemStack result;
                    if (!(recipe instanceof UnmoldRecipe) || !recipe.func_77569_a(craftMatrix, world) || (result = recipe.func_77572_b(craftMatrix)).func_190926_b()) continue;
                    ItemStack moldResult = ((UnmoldRecipe)recipe).getMoldResult(stack);
                    player.func_184611_a(hand, result);
                    if (!moldResult.func_190926_b()) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)moldResult);
                        continue;
                    }
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), TFCSounds.CERAMIC_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        Metal metal;
        IFluidHandler capFluidHandler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (capFluidHandler instanceof IMoldHandler && (metal = ((IMoldHandler)capFluidHandler).getMetal()) != null) {
            return super.func_77667_c(stack) + "." + metal.getRegistryName().func_110623_a();
        }
        return super.func_77667_c(stack);
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        return CapabilityContainerListener.readShareTag(stack);
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityContainerListener.applyShareTag(stack, nbt);
    }

    public Metal.ItemType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FilledMoldCapability(nbt);
    }

    @Override
    public boolean canStack(ItemStack stack) {
        IMoldHandler moldHandler = (IMoldHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        return moldHandler == null || moldHandler.getMetal() == null;
    }

    private class FilledMoldCapability
    extends ItemHeatHandler
    implements ICapabilityProvider,
    IMoldHandler {
        private final FluidTank tank = new FluidTank(100);
        private IFluidTankProperties[] fluidTankProperties;

        FilledMoldCapability(NBTTagCompound nbt) {
            if (nbt != null) {
                this.deserializeNBT(nbt);
            }
        }

        @Override
        @Nullable
        public Metal getMetal() {
            return this.tank.getFluid() != null ? FluidsTFC.getMetalFromFluid(this.tank.getFluid().getFluid()) : null;
        }

        @Override
        public int getAmount() {
            return this.tank.getFluidAmount();
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.fluidTankProperties == null) {
                this.fluidTankProperties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(this.tank)};
            }
            return this.fluidTankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            Metal metal;
            if (resource != null && (metal = FluidsTFC.getMetalFromFluid(resource.getFluid())) != null && ItemMold.this.type.hasMold(metal)) {
                int fillAmount = this.tank.fill(resource, doFill);
                if (fillAmount == this.tank.getFluidAmount()) {
                    this.updateFluidData();
                }
                return fillAmount;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.getTemperature() >= this.meltTemp ? this.tank.drain(resource, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.getTemperature() > this.meltTemp) {
                FluidStack stack = this.tank.drain(maxDrain, doDrain);
                if (this.tank.getFluidAmount() == 0) {
                    this.updateFluidData();
                }
                return stack;
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
            Metal metal = this.getMetal();
            if (metal != null) {
                String desc = TextFormatting.DARK_GREEN + I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{this.getAmount()});
                desc = this.isMolten() ? desc + I18n.func_135052_a((String)"tfc.tooltip.liquid", (Object[])new Object[0]) : desc + I18n.func_135052_a((String)"tfc.tooltip.solid", (Object[])new Object[0]);
                text.add(desc);
            }
            IMoldHandler.super.addHeatInfo(stack, text);
        }

        @Override
        public float getHeatCapacity() {
            return this.heatCapacity;
        }

        @Override
        public float getMeltTemp() {
            return this.meltTemp;
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHeat.ITEM_HEAT_CAPABILITY;
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? this : null);
        }

        @Override
        @Nonnull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.getTemperature() <= 0.0f) {
                nbt.func_74772_a("ticks", -1L);
                nbt.func_74776_a("heat", 0.0f);
            } else {
                nbt.func_74772_a("ticks", this.lastUpdateTick);
                nbt.func_74776_a("heat", this.temperature);
            }
            return this.tank.writeToNBT(nbt);
        }

        @Override
        public void deserializeNBT(@Nullable NBTTagCompound nbt) {
            if (nbt != null) {
                this.temperature = nbt.func_74760_g("heat");
                this.lastUpdateTick = nbt.func_74763_f("ticks");
                this.tank.readFromNBT(nbt);
            }
            this.updateFluidData();
        }

        private void updateFluidData() {
            this.updateFluidData(this.tank.getFluid());
        }

        private void updateFluidData(@Nullable FluidStack fluid) {
            Metal metal;
            this.meltTemp = Heat.maxVisibleTemperature();
            this.heatCapacity = 1.0f;
            if (fluid != null && (metal = FluidsTFC.getMetalFromFluid(fluid.getFluid())) != null) {
                this.meltTemp = metal.getMeltTemp();
                this.heatCapacity = metal.getSpecificHeat();
            }
        }
    }
}

